<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Customizer\Theme Settings
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * The config array for setting up a Customizer panel, sections within that panel, settings and controls.
 *
 * If child theme contains a `customizer-theme-settings.php` config, it will be used instead of this config.
 *
 * @since 2.6.0
 */
return [
	'genesis' => [
		'title'          => __( 'Theme Settings', 'genesis' ),
		'description'    => __( 'Customize the various theme settings.', 'genesis' ),
		'theme_supports' => 'genesis-customizer-theme-settings',
		'settings_field' => 'genesis-settings',
		'control_prefix' => 'genesis',
		'sections'       => [
			'genesis_updates'      => [
				'title'          => __( 'Updates', 'genesis' ),
				'panel'          => 'genesis',
				'theme_supports' => 'genesis-auto-updates',
				'controls'       => [
					'update'               => [
						'label'       => __( 'Check For Updates', 'genesis' ),
						/* translators: %s: Link to privacy policy */
						'description' => sprintf( __( 'By checking this box, you allow Genesis to periodically check for updates. Update requests send information about your site including software and theme data, as well as the site’s URL and locale. See the <a href="%s" target="_blank" rel="noopener noreferrer">privacy policy</a>.', 'genesis' ), 'https://www.studiopress.com/go/privacy-policy/' ),
						'section'     => 'genesis_updates',
						'type'        => 'checkbox',
						'settings'    => [
							'default' => 1,
						],
					],
					'update_email_address' => [
						'label'       => __( 'Email Address', 'genesis' ),
						'description' => __( 'If you provide an email address below, you will be notified via email when a new version of Genesis is available. Your email address is not sent to us.', 'genesis' ),
						'section'     => 'genesis_updates',
						'type'        => 'email',
						'input_attrs' => [
							'placeholder' => __( 'Email Address', 'genesis' ),
						],
						'settings'    => [
							'default' => '',
						],
					],

				],
			],
			'genesis_header'       => [
				'active_callback' => 'genesis_show_header_customizer_callback',
				'title'           => __( 'Header', 'genesis' ),
				'panel'           => 'genesis',
				'controls'        => [
					'blog_title' => [
						'label'    => __( 'Use for site title/logo:', 'genesis' ),
						'section'  => 'genesis_header',
						'type'     => 'select',
						'choices'  => [
							'text'  => __( 'Dynamic Text', 'genesis' ),
							'image' => __( 'Image logo', 'genesis' ),
						],
						'settings' => [
							'default' => 'text',
						],
					],
				],
			],
			'genesis_color_scheme' => [
				'active_callback' => 'genesis_has_color_schemes',
				'theme_supports'  => 'genesis-style-selector',
				'title'           => __( 'Color Scheme', 'genesis' ),
				'panel'           => 'genesis',
				'controls'        => [
					'style_selection' => [
						'label'    => __( 'Select Color Style', 'genesis' ),
						'section'  => 'genesis_color_scheme',
						'type'     => 'select',
						'choices'  => genesis_get_color_schemes_for_customizer(),
						'settings' => [
							'default' => '',
						],
					],
				],
			],
			'genesis_layout'       => [
				'active_callback' => 'genesis_has_multiple_layouts',
				'title'           => __( 'Site Layout', 'genesis' ),
				'panel'           => 'genesis',
				'controls'        => [
					'site_layout' => [
						'label'    => __( 'Select Site Layout', 'genesis' ),
						'section'  => 'genesis_layout',
						'type'     => 'select',
						'choices'  => genesis_get_layouts_for_customizer(),
						'settings' => [
							'default' => '',
						],
					],
				],
			],
			'genesis_breadcrumbs'  => [
				'theme_supports' => 'genesis-breadcrumbs',
				'title'          => __( 'Breadcrumbs', 'genesis' ),
				'description'    => __( 'Select the pages which should display breadcrumbs.', 'genesis' ),
				'panel'          => 'genesis',
				'controls'       => [
					'breadcrumb_home'       => [
						'active_callback' => 'genesis_posts_show_on_front',
						'label'           => __( 'Breadcrumbs on Homepage', 'genesis' ),
						'section'         => 'genesis_breadcrumbs',
						'type'            => 'checkbox',
						'settings'        => [
							'default' => 0,
						],
					],
					'breadcrumb_front_page' => [
						'active_callback' => 'genesis_page_show_on_front',
						'label'           => __( 'Breadcrumbs on Homepage', 'genesis' ),
						'section'         => 'genesis_breadcrumbs',
						'type'            => 'checkbox',
						'settings'        => [
							'default' => 0,
						],
					],
					'breadcrumb_posts_page' => [
						'active_callback' => 'genesis_page_show_on_front',
						'label'           => __( 'Breadcrumbs on Posts page', 'genesis' ),
						'section'         => 'genesis_breadcrumbs',
						'type'            => 'checkbox',
						'settings'        => [
							'default' => 0,
						],
					],
					'breadcrumb_single'     => [
						'label'    => __( 'Breadcrumbs on Single Posts', 'genesis' ),
						'section'  => 'genesis_breadcrumbs',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
					'breadcrumb_page'       => [
						'label'    => __( 'Breadcrumbs on Pages', 'genesis' ),
						'section'  => 'genesis_breadcrumbs',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
					'breadcrumb_archive'    => [
						'label'    => __( 'Breadcrumbs on Archives', 'genesis' ),
						'section'  => 'genesis_breadcrumbs',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
					'breadcrumb_404'        => [
						'label'    => __( 'Breadcrumbs on 404 page', 'genesis' ),
						'section'  => 'genesis_breadcrumbs',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
					'breadcrumb_attachment' => [
						'label'    => __( 'Breadcrumbs on Attachment/Media', 'genesis' ),
						'section'  => 'genesis_breadcrumbs',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
				],
			],
			'genesis_comments'     => [
				'title'    => __( 'Comments and Trackbacks', 'genesis' ),
				'panel'    => 'genesis',
				'controls' => [
					'comments_posts'   => [
						'label'    => __( 'Enable Comments on Posts', 'genesis' ),
						'section'  => 'genesis_comments',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 1,
						],
					],
					'comments_pages'   => [
						'label'    => __( 'Enable Comments on Pages', 'genesis' ),
						'section'  => 'genesis_comments',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 1,
						],
					],
					'trackbacks_posts' => [
						'label'    => __( 'Enable Trackbacks on Posts', 'genesis' ),
						'section'  => 'genesis_comments',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
					'trackbacks_pages' => [
						'label'    => __( 'Enable Trackbacks on Pages', 'genesis' ),
						'section'  => 'genesis_comments',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
				],
			],
			'genesis_single'       => [
				'title'       => __( 'Singular Content', 'genesis' ),
				'description' => __( 'Modify the settings for individual entries such as posts and pages.', 'genesis' ),
				'panel'       => 'genesis',
				'controls'    => [
					'entry_meta_before_content' => [
						'label'       => __( 'Entry Meta (above content)', 'genesis' ),
						/* translators: %s: Link to post shortcodes documentation */
						'description' => sprintf( __( 'The entry meta text that will appear above your entry content. Can include <a href="%s" target="_blank" rel="noopener noreferrer">post shortcodes</a>.', 'genesis' ), 'https://studiopress.github.io/genesis/basics/genesis-shortcodes/#post-shortcodes' ),
						'section'     => 'genesis_single',
						'type'        => 'textarea',
						'settings'    => [
							'default' => '[post_date] ' . __( 'by', 'genesis' ) . ' [post_author_posts_link] [post_comments] [post_edit]',
						],
					],
					'entry_meta_after_content'  => [
						'label'       => __( 'Entry Meta (below content)', 'genesis' ),
						/* translators: %s: Link to post shortcodes documentation */
						'description' => sprintf( __( 'The entry meta text that will appear below your entry content. Can include <a href="%s" target="_blank" rel="noopener noreferrer">post shortcodes</a>.', 'genesis' ), 'https://studiopress.github.io/genesis/basics/genesis-shortcodes/#post-shortcodes' ),
						'section'     => 'genesis_single',
						'type'        => 'textarea',
						'settings'    => [
							'default' => '[post_categories] [post_tags]',
						],
					],
				],
			],
			'genesis_archives'     => [
				'title'    => __( 'Content Archives', 'genesis' ),
				'panel'    => 'genesis',
				'controls' => [
					'content_archive'           => [
						'label'    => __( 'Select one of the following', 'genesis' ),
						'section'  => 'genesis_archives',
						'type'     => 'select',
						'choices'  => [
							'full'     => __( 'Entry content', 'genesis' ),
							'excerpts' => __( 'Entry excerpts', 'genesis' ),
						],
						'settings' => [
							'default' => 'full',
						],
					],
					'content_archive_limit'     => [
						'label'    => __( 'Limit content to how many characters? (0 for no limit)', 'genesis' ),
						'section'  => 'genesis_archives',
						'type'     => 'number',
						'settings' => [
							'default' => 0,
						],
					],
					'content_archive_thumbnail' => [
						'label'    => __( 'Display the featured image?', 'genesis' ),
						'section'  => 'genesis_archives',
						'type'     => 'checkbox',
						'settings' => [
							'default' => 0,
						],
					],
					'image_size'                => [
						'label'    => __( 'Featured Image Size', 'genesis' ),
						'section'  => 'genesis_archives',
						'type'     => 'select',
						'choices'  => genesis_get_image_sizes_for_customizer(),
						'settings' => [
							'default' => '',
						],
					],
					'image_alignment'           => [
						'label'    => __( 'Featured Image Alignment', 'genesis' ),
						'section'  => 'genesis_archives',
						'type'     => 'select',
						'choices'  => [
							''            => __( 'None', 'genesis' ),
							'alignleft'   => __( 'Left', 'genesis' ),
							'alignright'  => __( 'Right', 'genesis' ),
							'aligncenter' => __( 'Center', 'genesis' ),
						],
						'settings' => [
							'default' => 'alignleft',
						],
					],
					'posts_nav'                 => [
						'label'    => __( 'Entry Pagination Type', 'genesis' ),
						'section'  => 'genesis_archives',
						'type'     => 'select',
						'choices'  => [
							'prev-next' => __( 'Previous / Next', 'genesis' ),
							'numeric'   => __( 'Numeric', 'genesis' ),
						],
						'settings' => [
							'default' => '',
						],
					],
				],
			],
			'genesis_footer'       => [
				'active_callback' => function() {
					return apply_filters( 'genesis_footer_output', '', '', '' ) === '';
				},
				'title'           => __( 'Footer', 'genesis' ),
				'panel'           => 'genesis',
				'controls'        => [
					'footer_text' => [
						/* translators: %s: Link to footer shortcodes documentation */
						'description' => sprintf( __( 'The text that will appear in your site footer. Can include <a href="%s" target="_blank" rel="noopener noreferrer">footer shortcodes</a>.', 'genesis' ), 'https://studiopress.github.io/genesis/basics/genesis-shortcodes/#footer-shortcodes' ),
						'section'     => 'genesis_footer',
						'type'        => 'textarea',
						'settings'    => [
							'default' => sprintf( '[footer_copyright before="%s "] · [footer_childtheme_link before="" after=" %s"] [footer_genesis_link url="https://www.studiopress.com/" before=""] · [footer_wordpress_link] · [footer_loginout]', __( 'Copyright', 'genesis' ), __( 'on', 'genesis' ) ),
						],
					],
				],
			],
			'genesis_scripts'      => [
				'title'    => __( 'Header/Footer Scripts', 'genesis' ),
				'panel'    => 'genesis',
				'controls' => [
					'header_scripts' => [
						'label'       => __( 'Header Scripts', 'genesis' ),
						/* translators: %s: </element> */
						'description' => sprintf( __( 'This code will output immediately before the closing %s tag in the document source.', 'genesis' ), genesis_code( esc_html( '</head>' ) ) ),
						'section'     => 'genesis_scripts',
						'type'        => 'textarea',
						'settings'    => [
							'default' => '',
						],
					],
					'footer_scripts' => [
						'label'       => __( 'Footer Scripts', 'genesis' ),
						/* translators: %s: </element> */
						'description' => sprintf( __( 'This code will output immediately before the closing %s tag in the document source.', 'genesis' ), genesis_code( esc_html( '</body>' ) ) ),
						'section'     => 'genesis_scripts',
						'type'        => 'textarea',
						'settings'    => [
							'default' => '',
						],
					],
				],
			],
		],
	],
];
